clear all

* Set Folder to output one

cd ..\Outputs

* Call dataset of revisions and shocks combined (COMB)

use COMB, clear

gen time=year+(qua-1)/4
egen t=group(year quarter)
tsset t 
	
local i=20
local fulllabel : variable label hlGY`i'
local lambda=substr("`fulllabel'",34,8)
disp "`fulllabel'"
disp "`lambda'"
twoway (line ORPgRpot3 time if time>=1970 & time<=1987, lwidth( medthick) lcolor(green) lpattern(longdash)) ///
(line ORPgRpot3 time if time> 1987 & time<=2012, lwidth( medthick) lcolor(green)) ///
(line hpGY`i' time if time>=1970 & time<=2012, lcolor(red) lwidth(thin)) ///
(line maGY20  time if time>=1970 & time<=2012, lcolor(black)) ///
(line maGT20  time if time>=1970 & time<=2012, lcolor(blue) lpattern(shortdash)) ///
, xtitle("") ytitle("percent per year") ///
legend(	label(1 "Potential GDP (Orphanides 2004)") ///
label(2 "Potential GDP (Greenbook)") ///
label(3 "HP-filtered Actual GDP, {&lambda}=2M") ///
label(4 "MA(20) Actual GDP") ///
label(5 "MA(20) TFP") ///
rows(5) ring(0) position(1)) ///
graphregion(color(white)) bgcolor(white) ///		
xlabel(1970(5)2010) ylabel(0(1)7)
	
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*				figure for the presentation: final
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local i=20
local fulllabel : variable label hlGY`i'
local lambda=substr("`fulllabel'",34,8)
disp "`fulllabel'"
disp "`lambda'"
twoway (line ORPgRpot3 time if time>=1970 & time<=1987, lwidth( medthick) lcolor(green) lpattern(longdash)) ///
(line ORPgRpot3 time if time> 1987 & time<=2012, lwidth( medthick) lcolor(green)) ///
(line hpGY`i' time if time>=1970 & time<=2012, lcolor(red) lwidth(thin)) ///
(line maGY20  time if time>=1970 & time<=2012, lcolor(black)) ///
(line maGT20  time if time>=1970 & time<=2012, lcolor(blue) lpattern(shortdash)) ///
, xtitle("") ytitle("percent per year") ///
legend(	label(1 "Potential GDP (Orphanides 2004)") ///
label(2 "Potential GDP (Greenbook)") ///
label(3 "HP-filtered Actual GDP, {&lambda}=2M") ///
label(4 "MA(20) Actual GDP") ///
label(5 "MA(20) TFP") ///
rows(5) ring(0) position(1)  region(lwidth(none))) ///
graphregion(color(white)) bgcolor(white) ///		
xlabel(1970(5)2010) ylabel(0(1)7) ///
name(step_final, replace)
	
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*				figure for the presentation: final - 1 
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local i=20
local fulllabel : variable label hlGY`i'
local lambda=substr("`fulllabel'",34,8)
disp "`fulllabel'"
disp "`lambda'"
twoway (line ORPgRpot3 time if time>=1970 & time<=1987, lwidth( medthick) lcolor(green) lpattern(longdash)) ///
(line ORPgRpot3 time if time> 1987 & time<=2012, lwidth( medthick) lcolor(green)) ///
(line hpGY`i' time if time>=1970 & time<=2012, lcolor(white) lwidth(thin)) ///
(line maGY20  time if time>=1970 & time<=2012, lcolor(white)) ///
(line maGT20  time if time>=1970 & time<=2012, lcolor(white) lpattern(shortdash)) ///
, xtitle("") ytitle("percent per year") ///
legend(	label(1 "Potential GDP (Orphanides 2004)") ///
label(2 "Potential GDP (Greenbook)") ///
label(3 "                                    ") ///
label(4 "                 ") ///
label(5 "          ") ///
rows(5) ring(0) position(1)  region(lwidth(none))) ///
graphregion(color(white)) bgcolor(white) ///		
xlabel(1970(5)2010) ylabel(0(1)7)	///
name(step1, replace)

*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*				figure for the presentation: final - 2
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local i=20
local fulllabel : variable label hlGY`i'
local lambda=substr("`fulllabel'",34,8)
disp "`fulllabel'"
disp "`lambda'"
twoway (line ORPgRpot3 time if time>=1970 & time<=1987, lwidth( medthick) lcolor(green) lpattern(longdash)) ///
(line ORPgRpot3 time if time> 1987 & time<=2012, lwidth( medthick) lcolor(green)) ///
(line hpGY`i' time if time>=1970 & time<=2012, lcolor(white) lwidth(thin)) ///
(line maGY20  time if time>=1970 & time<=2012, lcolor(white)) ///
(line maGT20  time if time>=1970 & time<=2012, lcolor(blue) lpattern(shortdash)) ///
, xtitle("") ytitle("percent per year") ///
legend(	label(1 "Potential GDP (Orphanides 2004)") ///
label(2 "Potential GDP (Greenbook)") ///
label(3 " ") ///
label(4 " ") ///
label(5 "MA(20) TFP") ///
rows(5) ring(0) position(1)  region(lwidth(none))) ///
graphregion(color(white)) bgcolor(white) ///		
xlabel(1970(5)2010) ylabel(0(1)7) ///
name(step2, replace)
	
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*				figure for the presentation: final - 3
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local i=20
local fulllabel : variable label hlGY`i'
local lambda=substr("`fulllabel'",34,8)
disp "`fulllabel'"
disp "`lambda'"
twoway (line ORPgRpot3 time if time>=1970 & time<=1987, lwidth( medthick) lcolor(green) lpattern(longdash)) ///
(line ORPgRpot3 time if time> 1987 & time<=2012, lwidth( medthick) lcolor(green)) ///
(line hpGY`i' time if time>=1970 & time<=2012, lcolor(red) lwidth(thin)) ///
(line maGY20  time if time>=1970 & time<=2012, lcolor(white)) ///
(line maGT20  time if time>=1970 & time<=2012, lcolor(blue) lpattern(shortdash)) ///
, xtitle("") ytitle("percent per year") ///
legend(	label(1 "Potential GDP (Orphanides 2004)") ///
label(2 "Potential GDP (Greenbook)") ///
label(3 "HP-filtered Actual GDP, {&lambda}=2M") ///
label(4 " ") ///
label(5 "MA(20) TFP") ///
rows(5) ring(0) position(1)  region(lwidth(none))) ///
graphregion(color(white)) bgcolor(white) ///		
xlabel(1970(5)2010) ylabel(0(1)7) ///
name(step3, replace)
	
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
*				figure for the presentation: final - 4
*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

local i=20
local fulllabel : variable label hlGY`i'
local lambda=substr("`fulllabel'",34,8)
disp "`fulllabel'"
disp "`lambda'"
twoway (line ORPgRpot3 time if time>=1970 & time<=1987, lwidth( medthick) lcolor(green) lpattern(longdash)) ///
(line ORPgRpot3 time if time> 1987 & time<=2012, lwidth( medthick) lcolor(green)) ///
(line hpGY`i' time if time>=1970 & time<=2012, lcolor(red) lwidth(thin)) ///
(line maGY20  time if time>=1970 & time<=2012, lcolor(black)) ///
(line maGT20  time if time>=1970 & time<=2012, lcolor(blue) lpattern(shortdash)) ///
, xtitle("") ytitle("percent per year") ///
legend(	label(1 "Potential GDP (Orphanides 2004)") ///
label(2 "Potential GDP (Greenbook)") ///
label(3 "HP-filtered Actual GDP, {&lambda}=2M") ///
label(4 "MA(20) Actual GDP") ///
label(5 "MA(20) TFP") ///
rows(5) ring(0) position(1)  region(lwidth(none))) ///
graphregion(color(white)) bgcolor(white) ///		
xlabel(1970(5)2010) ylabel(0(1)7) ///
name(step_final, replace)
